<meta property="og:url" content="{{ Request::url() }}" />
<meta property="og:type" content="Article">
<meta property="og:title" content="{{ $viewproduct->product_name }}">
<meta property="og:description" content="{{ $viewproduct->product_name }}">
<meta property="og:image" content="{{ url('/public/productImage') }}/{{ $viewproduct->image }}" />

@extends('User.layouts.master')
@section('body')






<div class="col-md-12">
    <div class="container-fluid">
        <div class="row">

            <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-3 d-none d-lg-block side-bar" style="width:21%!important;">
                @include('User.layouts.sidmenu')
            </div><!----------End Sidebar-------->

            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 pb-5 main-bar" >
                <div class="col-md-12 mt-3 p-3 bg-white breadcumbs">
                    <li><a href="{{ url('/') }}"><i class="bi bi-house-fill"></i>&nbsp;&nbsp;Home</a></li>
                    <li><i class="bi bi-chevron-right"></i></li>
                    <li>{{ $viewproduct->product_name }}</li>
                </div>


                <div class="col-md-12 mt-4 single bg-white rounded pb-4 p-3 p-lg-0">
                    <div class="row">
                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12 p-4">

                            <div class="simpleLens-gallery-container" id="demo-1">
                                <div class="simpleLens-container border" style="width: 100%;">
                                    <div class="simpleLens-big-image-container ">

                                        <a class="simpleLens-lens-image"
                                        data-lens-image="{{ asset('public/productImage') }}/{{ $viewproduct->image }}">

                                        <img src="{{ asset('public/productImage') }}/{{ $viewproduct->image }}"
                                        class="simpleLens-big-image p-2">
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>



                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12">
                        <br>
                        <strong>{{ $viewproduct->product_name }}</strong><br>
                        <span><b>SKU:</b> {{ $viewproduct->product_id }}</span><br><br>
                        @if($viewproduct->stock_status == 1)
                        <span class="bg-success text-light rounded" style="padding: 2px 10px; font-size: 13px;">Stock Available</span>
                        @else
                        <span class="bg-danger text-light rounded" style="padding: 2px 10px; font-size: 13px;">Stock Out</span>
                        @endif
                       


                        @if($viewproduct->product_weight)
                        <p class="rounded" style=" color:#000;background:transparent;padding: 2px 0px; font-size: 13px;"> <strong>{{ $viewproduct->product_weight }}</strong> </p>
                        @endif

                        <br><br>

                        <label>৳ {{ number_format($viewproduct->sale_price, 2, '.', ',') }}</label>

                        <!--@if ($viewproduct->discount_price > 0)
                        <del>৳ {{ number_format($viewproduct->sale_price, 2, '.', ',') }}</del>
                        @endif-->

                        <br>




                        <div class="quentity mt-3">
                            <label>Quentity</label><br>
                            <input type="number"  min="{{ $viewproduct->min_qunt }}" name="Quantity-{{ $viewproduct->id }}"
                            id="Quantity-{{ $viewproduct->id }}" value="{{ $viewproduct->min_qunt }}">
                        </div>

                        <div class="mt-4">
                            <div class="col-md-12">
                                @if($viewproduct->stock_status == 1)
                                <button class="cart btn-success w-50 cart_btn" onclick="AddCart('{{ $viewproduct->id }}')" ><i class="fa fa-shopping-basket" aria-hidden="true"></i>&nbsp;&nbsp;Add To Bag</button>
                                @else
                                <button class="cart btn-success w-50" style="cursor: not-allowed;"><i class="fa fa-shopping-basket" aria-hidden="true"></i>&nbsp;&nbsp;Add To Bag</button>
                                @endif
                            </div>
                        </div>


                        <div class="mt-4">
                            <span>Share With :</span><br>
                            <div class="addthis_inline_share_toolbox_0v9d"></div>

                        </div>


                    </div> 



                </div>
            </div><!--------------End Product's--------------------->





            <div class="col-md-12 bg-white p-0 p-4 details mt-4">

                <ul class="nav nav-tabs" id="myTab" role="tablist">

                    <li class="nav-item">

                        <a class="nav-link active" id="home-tab" data-toggle="tab" href="#Description" role="tab"
                        aria-controls="home" aria-selected="true">Description</a>

                    </li>

                </ul>



                <div class="tab-content" id="myTabContent">

                    <div class="tab-pane fade show active mt-3" id="Description" role="tabpanel" aria-labelledby="home-tab">

                        <h4 class="font-weight-bold text-uppercase">{{ $viewproduct->product_name }}</h4>

                        <span>
                         {!! $viewproduct->product_details !!}
                     </span>

                 </div>


             </div>
         </div>



         <div class="col-md-12 mt-5 cathead">
            <strong>Related Products</strong>
            <div class="row">

               @if (isset($related_product))
               @foreach ($related_product as $r)
               @php
               $productname = str_replace(['%', '/', ' '], '-', $r->product_name);
               @endphp



               <div class="col-xl-3 col-lg-3 col-md-3 col-sm-4 col-6 mt-4">
                <div class="bg-white product p-2">
                    <center style="width: 100%;">

                        <a href="{{ url('product') }}/{{ $productname }}/{{ $r->product_id }}">

                            <img src="{{ asset('public/productImage') }}/{{ $r->image }}" alt="">

                        </a>

                        <br>
                        <a href="{{ url('product') }}/{{ $productname }}/{{ $r->product_id }}" class="text-dark fw-bold productname mt-3 text-center">{{ $r->product_name }}<br><span>৳ {{ $r->current_price }}</span></a>
                        <div class="mt-2"><button class="btn btn-success btn-sm" onclick="AddCart('{{ $r->id }}')" >Add To Bag</button></div>
                    </center>
                </div>
            </div>


            @endforeach
            @endif






        </div>
    </div>





</div>


</div>
</div>
</div>









@endsection
