<?php

namespace App\Http\Controllers;
use App\Mail\RegisterNotice;
use Illuminate\Support\Facades\Mail;
use Illuminate\Http\Request;
use DB;
use Session;
use Auth;
use Cookie;
use App\guest;
use App\DealerArea;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use Laravel\Socialite\Facades\Socialite;
use App\Lib\Adnsms\lib\AdnSmsNotification;
use Image;
use GuzzleHttp\Client;


class guestController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
		$districts = DB::table('bdgeo')->select('id','district')->groupBy('district')->orderBy('district','asc')->get();
        return view('User.Guest.register',compact('districts'));
    }
	public function getUpazilla(Request $request){
		 $district = $request->district;
		return $upazillas = DB::table('bdgeo')->select('id','upazila')->where('district',$district)->groupBy('upazila')->orderBy('upazila','asc')->get();
		
		
	}
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

      $validator = Validator::make($request->all(), [
        'first_name' => 'required|max:100',
        'rank' => 'required',
        //   'last_name' => 'required|max:100',
        //'email' => 'unique:guest|max:100',
        'phone' => 'required|min:11|unique:guest',
        'address' => 'nullable',
        'password' => 'min:6',
        'confirm_password' => 'required_with:password|same:password|min:6'
      ]);

      if ($validator->fails()) {
        return redirect()->back()
        ->withErrors($validator)
        ->withInput();
      }
        $status = 1;
      if('Dealer'==$request->rank){
          $status = 0;
      }
      $data = array(
        'first_name'=>$request->first_name,
            // 'last_name'=>$request->last_name,
        'email'=>$request->email,
        'phone'=>$request->phone,
        'address'=>$request->address,
        'vessel_name'=>$request->vessel_name,
        'rank'=>$request->rank,
        'password'=>Hash::make($request->password),
        'set_password'=>$request->password,
        'district'=>$request->district,
        'upazila'=>$request->upazila,
        'status'=>$status,
      );
//dd($data);
      $insert = guest::create($data);
	   $setting = DB::table('settings')->select('hotline','email')->first();
        if('Dealer'==$request->rank){
            $notification=array(
                'messege'   =>'Registration Successfull. Please Wait for Verify',
                'alert-type'=>'success'
            );
			$this->send_sms('Registration Successfull. Please Wait for Verify',$request->phone);
			 Mail::to($setting->email)->send(new RegisterNotice());
			 return redirect('/user-login')->with($notification); 
            //return redirect()->back()->with($notification);
        }
      Session::forget('do_reg_first');

      $session_id = Session::getId();
      $session = DB::table('shopping_carts')->where('session_id',$session_id)->first();

      $setcheck =  Auth::guard('guest')->loginUsingId($insert->id);

      if($setcheck)
      {
       $session_id_up = Session::getId();
       if ($session) {
        $sessions = DB::table('shopping_carts')->where('session_id',$session->session_id)->update(['session_id'=>$session_id_up]);
      }

    }

    if(isset($sessions)>0)
    {
     $notification=array(
      'messege'   =>'Registration Successfull',
      'alert-type'=>'success'
    );
  $this->send_sms('Registration Successfull.',$request->phone);
   Mail::to($setting->email)->send(new RegisterNotice());
     return redirect('Checkout')->with($notification);  
   }
   else
   {
    $notification=array(
      'messege'   =>'Registration Successfull',
      'alert-type'=>'success'
    );
  $this->send_sms('Registration Successfull.',$request->phone);
   Mail::to($setting->email)->send(new RegisterNotice());
   return redirect('/user-login')->with($notification); 
    //return redirect()->back()->with($notification);   
  }



}

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function userLogin()
    {
      return view('User.Guest.signin');
    }

    public function guestLogin(Request $request)
    {

     $session_id = Session::getId();


     $user = DB::table('guest')->where('phone', $request->email)->first();
     if(!$user){
         Session::put('do_reg_first', 'Please Do Registration First !');
		 return redirect('/user-login')->with('error','Please Do Registration First');
       // return redirect('user-Register')->with('error','Please Do Registration First');
     }

 

     $creadential=['email'=>$request->email,'password'=>$request->password];

     $session = DB::table('shopping_carts')->where('session_id',$session_id)->first();


     if (Auth::guard('guest')->attempt($creadential)) 
     {
       if($request->has('remember'))
       {
        Cookie::queue('user',$request->email);
        Cookie::queue('password',$request->password);
      }

      if (Auth::guard('guest')->user()->status == '0') 
      {
          //dd('dukce');
          return redirect('/guest-logout')->with('error','Waiting for approval!');
        //return redirect()->back()->with('error','Waiting for approval!');

      }

      $session_id_up = Session::getId();
      if ($session) {
        $session = DB::table('shopping_carts')->where('session_id',$session->session_id)->update(['session_id'=>$session_id_up]);
      }

      $notification=array(
        'messege'   =>'Login Successfully Done',
        'alert-type'=>'success'
      );

      return redirect('/userdashboard')->with($notification); 


    }

    $creadentials=['phone'=>$request->email,'password'=>$request->password];

    if (Auth::guard('guest')->attempt($creadentials)) 
    {
     if($request->has('remember'))
     {
      Cookie::queue('user',$request->email);
      Cookie::queue('password',$request->password);
    }

    if (Auth::guard('guest')->user()->status == '0') 
    {
     // Auth::guard('guest')->logout();
        return redirect('/guest-logout')->with('error','Waiting for approval!');
    }



    $session_id_up = Session::getId();
    if ($session) {
      $session = DB::table('shopping_carts')->where('session_id',$session->session_id)->update(['session_id'=>$session_id_up]);
    }

    $notification=array(
      'messege'   =>'Login Successfull',
      'alert-type'=>'success'
    );
    
    Session::forget('do_reg_first');

    return redirect('/userdashboard')->with($notification); 


  }
  else
  {
    return redirect()->back()->with('error','E-mail/phone or Password Does not match!');
  }
}

public function guestLogin_redirect(Request $request)
{

 $session_id = Session::getId();

 $creadential=['email'=>$request->email,'password'=>$request->password];

 $session = DB::table('shopping_carts')->where('session_id',$session_id)->first();

 if (Auth::guard('guest')->attempt($creadential)) 
 {
   if($request->has('remember'))
   {
    Cookie::queue('user',$request->email);
    Cookie::queue('password',$request->password);
  }

  if (Auth::guard('guest')->user()->status == '0') 
  {
    Auth::guard('guest')->logout();
    $notification=array(
      'messege'   =>'Pending your registration',
      'alert-type'=>'error'
    );

    return redirect()->back()->with($notification);
  }
  $session_id_up = Session::getId();
  $session = DB::table('shopping_carts')->where('session_id',$session->session_id)->update(['session_id'=>$session_id_up]);


  $notification=array(
    'messege'   =>'Login Successfull',
    'alert-type'=>'success'
  );

  return redirect('/Checkout')->with($notification); 


}

$creadentials=['phone'=>$request->email,'password'=>$request->password];

if (Auth::guard('guest')->attempt($creadentials)) 
{
 if($request->has('remember'))
 {
  Cookie::queue('user',$request->email);
  Cookie::queue('password',$request->password);
}

if (Auth::guard('guest')->user()->status == '0') 
{
  Auth::guard('guest')->logout();
  $notification=array(
    'messege'   =>'Pending your registration',
    'alert-type'=>'error'
  );

  return redirect()->back()->with($notification);
}

$session_id_up = Session::getId();
$session = DB::table('shopping_carts')->where('session_id',$session->session_id)->update(['session_id'=>$session_id_up]);


$notification=array(
  'messege'   =>'Login Successfull',
  'alert-type'=>'success'
);

return redirect('/Checkout')->with($notification); 


}
else
{
  $notification=array(
    'messege'   =>'Password and E-mail/Mobile Does not match!',
    'alert-type'=>'error'
  );

  return redirect()->back()->with($notification); 
}
} 

public function userdashboard()
{

  $today_salse_discount = DB::table('invoices')
   ->join('shopping_carts','shopping_carts.session_id','invoices.session_id')
   ->where('invoices.guest_id',Auth('guest')->user()->id)
   ->whereDate('invoices.default_deposite_time',date('Y-m-d'))
   ->sum('shopping_carts.discount_price');
   
   $all_salse_discount = DB::table('invoices')
   ->join('shopping_carts','shopping_carts.session_id','invoices.session_id')
   ->where('invoices.guest_id',Auth('guest')->user()->id)
   ->sum('shopping_carts.discount_price');
   $all_salse_current_price = DB::table('invoices')
   ->join('shopping_carts','shopping_carts.session_id','invoices.session_id')
   ->where('invoices.guest_id',Auth('guest')->user()->id)
   ->sum('shopping_carts.current_price');
   
   
    $all_upazila = DB::table('dealer_areas')->where('guest_id',Auth('guest')->user()->id)->pluck('upazila')->toArray();
	//dd($all_upazila);
	array_push($all_upazila,Auth('guest')->user()->upazila);
	//dd($all_upazila);
    $all_salse_discount_upazila = DB::table('invoices')
	  ->join('guest','invoices.guest_id','guest.id')
	  ->join('shopping_carts','shopping_carts.session_id','invoices.session_id')
	  ->where('guest.id','!=',Auth('guest')->user()->id)
	  ->whereIn('guest.upazila',$all_upazila)
	  ->sum('shopping_carts.current_price');

	//dd($all_salse_discount_upazila);
  $data = DB::table('invoices')
  ->join('delivery_infos','delivery_infos.id','invoices.delivery_id')
  ->where('invoices.guest_id',Auth('guest')->user()->id)
  ->select('invoices.*','delivery_infos.*')
  ->groupby('invoices.invoice_id')
  ->get();

  // $pending = DB::table('invoices')
  // ->join('delivery_infos','delivery_infos.id','invoices.delivery_id')
  // ->join('districts','districts.id','delivery_infos.district_id')
  // ->where('invoices.guest_id',Auth('guest')->user()->id)
  // ->where('invoices.status',0)
  // ->select('invoices.*','delivery_infos.*','districts.district_name')
  // ->groupby('invoices.invoice_id')
  // ->get();

  $pending = DB::table('invoices')
  ->join('delivery_infos','delivery_infos.id','invoices.delivery_id')
  ->where('invoices.guest_id',Auth('guest')->user()->id)
  ->where('invoices.status',0)
  ->select('invoices.*','delivery_infos.*')
  ->groupby('invoices.invoice_id')
  ->get();


  // $processing = DB::table('invoices')
  // ->join('delivery_infos','delivery_infos.id','invoices.delivery_id')
  // ->join('districts','districts.id','delivery_infos.district_id')
  // ->where('invoices.guest_id',Auth('guest')->user()->id)
  // ->where('invoices.status',1)
  // ->select('invoices.*','delivery_infos.*','districts.district_name')
  // ->groupby('invoices.invoice_id')
  // ->get();


  $processing = DB::table('invoices')
  ->join('delivery_infos','delivery_infos.id','invoices.delivery_id')
  ->where('invoices.guest_id',Auth('guest')->user()->id)
  ->where('invoices.status',1)
  ->select('invoices.*','delivery_infos.*')
  ->groupby('invoices.invoice_id')
  ->get();


  // $delivered = DB::table('invoices')
  // ->join('delivery_infos','delivery_infos.id','invoices.delivery_id')
  // ->join('districts','districts.id','delivery_infos.district_id')
  // ->where('invoices.guest_id',Auth('guest')->user()->id)
  // ->where('invoices.status',2)
  // ->select('invoices.*','delivery_infos.*','districts.district_name')
  // ->groupby('invoices.invoice_id')
  // ->get();


  $delivered = DB::table('invoices')
  ->join('delivery_infos','delivery_infos.id','invoices.delivery_id')
  ->where('invoices.guest_id',Auth('guest')->user()->id)
  ->where('invoices.status',2)
  ->select('invoices.*','delivery_infos.*')
  ->groupby('invoices.invoice_id')
  ->get();




  $product = DB::table('invoices')
  ->join('shopping_carts','shopping_carts.session_id','invoices.session_id')
  ->join('product_productinfo','product_productinfo.id','shopping_carts.product_id')
  ->select('product_productinfo.product_name','product_productinfo.current_price','product_productinfo.product_id','invoices.invoice_id','shopping_carts.quantity')
  ->get();


  return view('User.Guest.dashboard',compact('data','product','pending','processing','delivered','today_salse_discount','all_salse_discount','all_salse_discount_upazila','all_salse_current_price'));
}


public function myprofileupdate(Request $request)
{


  if ($request->password !='') 
  {

    $validator = Validator::make($request->all(), [
      'first_name' => 'required|max:100',
      'password' => 'required|min:6',
      'phone' => 'required',
      'address' => 'required',
    ]);

    if ($validator->fails()) {
      return redirect()->back()
      ->withErrors($validator)
      ->withInput();
    }

    $data = array(
      'first_name'=>$request->first_name,
      'last_name'=>$request->last_name,
      'email'=>$request->email,
      'phone'=>$request->phone,
      'address'=>$request->address,
      'password'=>Hash::make($request->password),
      'set_password'=>$request->password,
    );  

  }
  else
  {

    $validator = Validator::make($request->all(), [
      'first_name' => 'required|max:100',
      'phone' => 'required',
      'address' => 'required',
    ]);

    if ($validator->fails()) {
      return redirect()->back()
      ->withErrors($validator)
      ->withInput();
    }

    $data = array(
      'first_name'=>$request->first_name,
      'last_name'=>$request->last_name,
      'email'=>$request->email,
      'phone'=>$request->phone,
      'address'=>$request->address,
    );

  }

  $insert = guest::where('id',Auth('guest')->user()->id)->update($data);

  $file = $request->file('image');
  if ($file) 
  {
    $imagename = Auth('guest')->user()->id.'.'.$file->getClientOriginalExtension();
    $file->move(public_path('/guestImage'),$imagename);
    DB::table('guest')->where('id',Auth('guest')->user()->id)->update(['image'=>$imagename]);
  }

  $notification=array(
    'messege'   =>'Update Successfull',
    'alert-type'=>'success'
  );

  return redirect()->back()->with($notification); 
}


public function guestLogout()
{
  Auth::guard('guest')->logout();
  $notification=array(
    'messege'   =>'Logout Successfull',
    'alert-type'=>'info'
  );

  return redirect('/user-login')->with($notification);
}


    // ================Facebook=============
public function redirectTofacebook()
{
  return Socialite::driver('facebook')->redirect();
}


public function handleFacebookCallback() {
  try {
    $user = Socialite::driver('facebook')->user();
            //   dd($user);
    $finduser = guest::where('provider_id', $user->id)->first();
            // dd($finduser);
    if ($finduser) {

      guest::where('provider_id', $user->id)->update([
        'first_name' => $user->name,
        'email' => $user->email,
        'avatar' =>$user->avatar,
      ]);

      Auth::guard('guest')->loginUsingId($finduser->id);
      return redirect('/userdashboard');
    } else {
      $newUser = guest::create([
        'first_name' => $user->name,
        'email' => $user->email,
        'provider_id' => $user->id,
        'avatar' =>$user->avatar,
      ]);
      Auth::guard('guest')->loginUsingId($newUser->id);
      return redirect('/userdashboard');
    }
  }
  catch(Exception $e) {
    return redirect('/');
  }
}





    // ================Twitter=============
public function redirectToTwitter()
{
  return Socialite::driver('twitter')->redirect();
}


public function handleTwitterCallback() 
{
  try {
    $user = Socialite::driver('twitter')->user();
    $finduser = guest::where('provider_id', $user->id)->first();
    if ($finduser) {
      Auth::guard('guest')->loginUsingId($finduser->id);
                // Auth::login($finduser);
      return redirect('/userdashboard');
    } else {
      $newUser = guest::create(['name' => $user->name, 'email' => $user->email, 'provider_id' => $user->id]);
      Auth::login($newUser);
      return redirect()->back();
    }
  }
  catch(Exception $e) {
    return redirect('/');
  }
}




    // ================Google=============
public function redirectToGoogle()
{
  return Socialite::driver('google')->redirect();
}


public function handleGoogleCallback() 
{
  try {
    $user = Socialite::driver('google')->user();
    $finduser = guest::where('provider_id', $user->id)->first();
    if ($finduser) {
      Auth::guard('guest')->loginUsingId($finduser->id);
                // Auth::login($finduser);
      return redirect('/userdashboard');
    } else {
      $newUser = guest::create(['name' => $user->name, 'email' => $user->email, 'provider_id' => $user->id]);
      Auth::login($newUser);
      return redirect()->back();
    }
  }
  catch(Exception $e) {
    return redirect('/');
  }
}

public function forgot_password()
{
  return view('User.Guest.forget_pass');
}


public function guest_forget(Request $request)
{
  $check = guest::where('phone',$request->phone)->first();
  $api = DB::table('settings')->first();

  if ($check) 
  {

    $getcode = rand(1000,9999);
    $code = guest::where('phone',$request->phone)->update(['code'=>$getcode]);
    
    $to = $request->phone;
	$token = "99752254071693846447b02b36190a035f16408b38f3ec06df1c";
	$message = "PaikariSale: Password Reset OTP - ".$getcode;

	$url = "http://api.greenweb.com.bd/api.php?json";


	$data= array(
	'to'=>"$to",
	'message'=>"$message",
	'token'=>"$token"
	); 
	$ch = curl_init(); 
	curl_setopt($ch, CURLOPT_URL,$url);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($ch, CURLOPT_ENCODING, '');
	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$smsresult = curl_exec($ch);

	//Result
	//echo $smsresult;

	//Error Display
	//echo curl_error($ch);

    
    
   /* $url = 'https://24smsbd.com/api/bulkSmsApi';
    
    $data = array('sender_id' => $api->senderid,
     'apiKey' => $api->api_key,
     'mobileNo' => $request->phone,
     'message' => "Password Reset OTP - ".$getcode,
     );
    
    
     $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);     
        $output = curl_exec($curl);
        curl_close($curl);
    
        echo $output;*/
    
    
    
    // $client = new Client();
    // $result = $client->request('POST', $api->api_url, [
    //   'form_params' => [
    //     'api_key'   => $api->api_key,
    //     'contacts'  => $request->phone,
    //     'senderid'  => $api->senderid,
    //     'msg'       =>  "Password Reset OTP - ".$getcode,
    //   ]
    // ]);
    // $response = $result->getBody();

    return redirect('/guest_forget_code/'.$request->phone);
  }
  else
  {

    $notification=array(
      'messege'   =>'Does not match Phone Number',
      'alert-type'=>'error'
    );

    return redirect()->back()->with($notification); 
  }
}



public function guest_forget_code($phone)
{
  $check = guest::where('phone',$phone)->first();
  if ($check) 
  {

    return view('User.Guest.forget_pass_code',compact('check'));

  }

}


public function guest_forget_code_check(Request $request)
{
  $check = guest::where('phone',$request->phone)->where('code',$request->code)->first();
  if ($check) 
  {

   $getcode = rand(1000,9999);
   $code = guest::where('phone',$request->phone)->update(['code'=>$getcode]);

   return view('User.Guest.forget_pass_reset',compact('check'));

 }
 else
 {
  $notification=array(
    'messege'   =>'Does not match Code',
    'alert-type'=>'error'
  );

  return redirect()->back()->with($notification); 
}
}

public function guest_forget_reset_done(Request $request)
{
        // return $request->all();
  $check = guest::where('phone',$request->phone)->first();
  if ($check) 
  {



    $validator = Validator::make($request->all(), [
      'password' => 'required',
      'confirm_password' => 'required_with:password|same:password|min:6',
    ]); 

    if ($validator->fails()) {
      return redirect()->back()
      ->withErrors($validator)
      ->withInput();
    }

    $data = array(
      'password'=>Hash::make($request->password),
      'set_password'=>$request->password,
    );

    $insert = guest::where('phone',$request->phone)->update($data);

    $getcode = rand(1000,9999);
    $code = guest::where('phone',$request->phone)->update(['code'=>$getcode]);

    $notification=array(
      'messege'   =>'Password Update Successfull',
      'alert-type'=>'success'
    );
    return redirect('/user-login')->with($notification);

  }

}

public function guest_reg_OTP(Request $request)
{
  $checked = guest::where('phone', $request->phone)->first();
  if($checked)
  {
    return '200';
  }
  else
  {
    $getcode = rand(1000,9999);
    $ck = DB::table('guest_verify')->where('phone',$request->phone)->first();

    if($ck)
    {
     $code = DB::table('guest_verify')->where('phone',$request->phone)->update(['code'=>$getcode]); 
   }
   else
   {
    $code = DB::table('guest_verify')->where('phone',$request->phone)->insert(['phone'=>$request->phone,'code'=>$getcode]);
  }
  
  
  $api = DB::table('settings')->first();



  $client = new Client();
  $result = $client->request('POST', $api->api_url, [
    'form_params' => [
      'api_key'   => $api->api_key,
      'contacts'  => $request->phone,
      'senderid'  => $api->senderid,
      'msg'       =>  "Register Account OTP ".$getcode,
    ]
  ]);
  $response = $result->getBody();



  return 'OTP Send Your Phone';
}

}

public function guest_reg_OTP_check(Request $request)
{

 $ck = DB::table('guest_verify')->where('phone',$request->phone)->where('code',$request->otp)->first();

 if($ck)
 {
  return 'matching';
}
else
{
  return '404';
}
}



public function allorder(){

  
  // $data = DB::table('invoices')
  // ->orderBy('invoices.id','DESC')
  // ->join('delivery_infos','delivery_infos.id','invoices.delivery_id')
  // ->join('districts','districts.id','delivery_infos.district_id')
  // ->where('invoices.guest_id',Auth('guest')->user()->id)
  // ->select('invoices.*','delivery_infos.*','districts.district_name')
  // ->groupby('invoices.invoice_id')
  // ->get();



  $data = DB::table('invoices')
  ->orderBy('invoices.id','DESC')
  ->join('delivery_infos','delivery_infos.id','invoices.delivery_id')
  ->where('invoices.guest_id',Auth('guest')->user()->id)
  ->select('invoices.*','delivery_infos.*')
  ->groupby('invoices.invoice_id')
  ->get();

  return view('User.Guest.allorder',compact('data'));

}
public function invoice_search(){
    $upazilas = DealerArea::where('guest_id',Auth('guest')->user()->id)->select('upazila as name')->get();
  return view('User.Guest.invoice_search',compact('upazilas'));
}
public function search_order(Request $request){
//        dd($request->all());
    $upazila = $request->upazila;
    $allUser = DB::table('guest')->where('upazila',$upazila)->pluck('id');
//    dd($allUser);
    $data = DB::table('invoices')
        ->orderBy('invoices.id','DESC')
        ->join('delivery_infos','delivery_infos.id','invoices.delivery_id')
        ->whereIn('invoices.guest_id',$allUser)
        ->select('invoices.*','delivery_infos.*')
        ->groupby('invoices.invoice_id')
        ->get();
    //dd($data);
   return view('User.Guest.search-order-result',compact('data','upazila'));
}


public function updateinformation(){
  return view('User.Guest.updateinformation');
}


public function profileupdate(Request $request){

  $data = array();
  $data['first_name'] = $request->first_name;
  $data['email'] = $request->email;
 /* $data['phone'] = $request->phone;
  $data['rank'] = $request->rank;*/
  $data['vessel_name'] = $request->vessel_name;

  DB::table('guest')->where('id',Auth('guest')->user()->id)->update($data);

}


public function changepassword(){

  return view('User.Guest.changepassword');

}



public function updatepassword(Request $request){

  $dbpassword       = Auth('guest')->user()->password;
  $old_password     = $request->old_password;
  $new_password     = $request->new_password;
  $confirm_password = $request->confirm_password;

  if (Hash::check($old_password, $dbpassword)) {

    if ($new_password === $confirm_password) {
      DB::table('guest')->where('id',Auth('guest')->user()->id)->update(['password'=>Hash::make($new_password)]);
      Auth('guest')->logout();
    }
    else{
     $notification=array(
      'messege'   =>'New Password & Confirm Password Not Match',
      'alert-type'=>'error'
    );
     return redirect()->back()->with($notification);
   }

 }
 else{
   $notification=array(
    'messege'   =>'Old Password does Not Match',
    'alert-type'=>'error',

  );
   return redirect()->back()->with($notification);
 }


 return redirect()->back();


}


public function profilechange(Request $request){


  $data = array();
  $newsimage          = $request->file('image');
  $old_image          = Auth('guest')->user()->image;

  if ($old_image) {

    // unlink($old_image);


    $image_one_name= hexdec(uniqid()).'.'.$newsimage->getClientOriginalExtension();
    Image::make($newsimage)->save('public/guestImage/'.$image_one_name,50);
    $data['image']='public/guestImage/'.$image_one_name;
    DB::table('guest')->where('id', Auth("guest")->user()->id)->update($data); 

  }

  else{
    $image_one_name= hexdec(uniqid()).'.'.$newsimage->getClientOriginalExtension();
    Image::make($newsimage)->save('public/guestImage/'.$image_one_name,50);
    $data['image']='public/guestImage/'.$image_one_name;
    DB::table('guest')->where('id', Auth("guest")->user()->id)->update($data);  
  }



}



}
