<?php

namespace App\Http\Controllers;

use App\DealerArea;
use App\guest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class DealerAreaController extends Controller
{

    public function index()
    {
        //$data = DealerArea::all();
        $data =  DB::table('dealer_areas')
             ->join('guest','guest.id','dealer_areas.guest_id')
                ->select('dealer_areas.id','dealer_areas.district','dealer_areas.upazila','guest.first_name','guest.phone')
                ->get();
        return view('Admin.dealer-area.index',compact('data'));
    }


    public function create()
    {
        $data['dealers'] = guest::Where('rank','Dealer')->select('id','first_name')->get();
        $data['districts'] = DB::table('bdgeo')->select('id','district')->groupBy('district')->orderBy('district','asc')->get();
        return view('Admin.dealer-area.create',$data);
    }


    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'guest_id' => 'required',
            'district' => 'required',
            'upazila' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }
       DealerArea::create([
            'guest_id' => $request->input('guest_id'),
            'district' => $request->input('district'),
            'upazila' => $request->input('upazila')
        ]);
        $notification=array(
            'messege'   =>'Dealer Area Successfull',
            'alert-type'=>'success'
        );

        return redirect()->back()->with($notification);
    }


    public function show(DealerArea $dealerArea)
    {
        //
    }

    public function edit(DealerArea $dealerArea)
    {
        //
    }


    public function update(Request $request, DealerArea $dealerArea)
    {
        //
    }


    public function destroy($id)
    {
        DealerArea::find($id)->delete();
        $notification=array(
            'messege'   =>'Dealer Area Deleted',
            'alert-type'=>'error'
        );

        return redirect()->back()->with($notification);
    }
}
